﻿using System;
using System.ComponentModel;
using System.Windows.Forms;

namespace ToDoList
{
    // Listing 22-2. Dostarczanie obiektów na potrzeby źródła danych.
    public partial class Form1 : Form
    {
        private BindingList<ToDoEntry> entries = new BindingList<ToDoEntry>();

        public Form1()
        {
            InitializeComponent();

            titleText.DataBindings.Add("Text", entriesSource, "Title", true,
                DataSourceUpdateMode.OnPropertyChanged);
            dueDatePicker.DataBindings.Add("Value", entriesSource, "DueDate", true,
            DataSourceUpdateMode.OnPropertyChanged);

            entriesSource.DataSource = entries;

            CreateNewItem();
        }

        private void CreateNewItem()
        {
            ToDoEntry newEntry = (ToDoEntry) entriesSource.AddNew();
            newEntry.Title = "Nowe zadanie";
            newEntry.DueDate = DateTime.Now;
            entriesSource.ResetCurrentItem();
        }

        // Listing 22-3. Obsługa zmian.
        private void entriesSource_ListChanged(object sender, ListChangedEventArgs e)
        {
            switch (e.ListChangedType)
            {
                case ListChangedType.ItemAdded:
                    MakeListViewItemForNewEntry(e.NewIndex);
                    break;
                case ListChangedType.ItemDeleted:
                    RemoveListViewItem(e.NewIndex);
                    break;
                case ListChangedType.ItemChanged:
                    UpdateListViewItem(e.NewIndex);
                    break;
            }
        }

        // Listing 22-4. Dodawanie nowych elementów do listy w momencie pojawienia się nowego zadania.
        private void MakeListViewItemForNewEntry(int newItemIndex)
        {
            ListViewItem item = new ListViewItem();
            item.SubItems.Add("");
            entriesListView.Items.Insert(newItemIndex, item);
        }

        // Listing 22-5. Zapewnienie aktualizacji danych w odpowiedzi na zdarzenie informujące o ich zmianie.
        private void UpdateListViewItem(int itemIndex)
        {
            ListViewItem item = entriesListView.Items[itemIndex];
            ToDoEntry entry = entries[itemIndex];
            item.SubItems[0].Text = entry.Title;
            item.SubItems[1].Text = entry.DueDate.ToShortDateString();
        }

        // Listing 22-6. Usuwanie z listy elementów reprezentujących usunięte zadania.
        private void RemoveListViewItem(int deletedItemIndex)
        {
            entriesListView.Items.RemoveAt(deletedItemIndex);
        }

        private void newButton_Click(object sender, EventArgs e)
        {
            CreateNewItem();
        }

        private void deleteButton_Click(object sender, EventArgs e)
        {
            if (entriesListView.SelectedIndices.Count != 0)
            {
                int entryIndex = entriesListView.SelectedIndices[0];
                entriesSource.RemoveAt(entryIndex);
            }
        }

        private void entriesListView_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (entriesListView.SelectedIndices.Count != 0)
            {
                int entryIndex = entriesListView.SelectedIndices[0];
                entriesSource.Position = entryIndex;
            }
        }
    }
}
